;Copyright (C) 2008 by Mattia Monga <mattia.monga@unimi.it>
bits 16                         ; 16 bit real mode
org 0x7C00                      ; origine indirizzo 0000:7C00
        
start:
        cld                     ; clears direction flag (index regs incremented)
        mov si, boot
        call message
working:
        mov si, work
        call message

        call waitenter
        jmp working

message:
        lodsb                   ; carica un byte da [DS:SI] in AL e inc SI
        cmp al, 0
        jz done
        mov ah, 0x0E            ; write char to screen in text mode
        mov bx, 0               ; BH page number BL foreground color
        int 0x10                ; write AL to screen (BIOS)
        jmp message
done:   ret

boot: db "Loading unuseful system...." , 10, 13, 0
work: db "I've done my unuseful stuff!" , 10, 13, 0 
cont: db "Hit ENTER to continue...", 10, 13, 0
wow: db "Great! Hello world!" , 10, 13, 0
        
waitenter: mov si, cont
           call message
           mov ah, 0
           int 0x16                ; Wait for keypress (BIOS)
           cmp al, 'm'
           jz egg
           cmp al, 'b'
           jz basic
           cmp al, 13
           jnz waitenter
           ret
egg:       mov si, wow
           call message
           jmp waitenter
basic:     int 0x18		; basic (BIOS)
           hlt

        times 510-($-$$) db 0
        dw 0xAA55
