/* Copyright (C) 2012 by Mattia Monga <mattia.monga@unimi.it> */
/* $Id$ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>

void lsofd(const char* name){
        int i;
        for (i=0; i<_POSIX_OPEN_MAX; i++){
                struct stat buf;
                if (fstat(i, &buf) == 0){
                        printf("%s fd:%d i-node: %d\n", name, i, buf.st_ino);
                }
        }
}

main(){
        pid_t pid;
        int f,  off;
        char    string[] = "Hello, world!\n";
        
        lsofd("padre (senza figli)");
        printf("padre (senza figli) pipe *\n");
        f = open("provaxxx.dat", O_CREAT|O_WRONLY|O_TRUNC, S_IRWXU);
        if (f == -1){
                perror("pipe");
                exit(1);
        }
        lsofd("padre (senza figli)");
        if (write(f, string, (strlen(string)+1)) != (strlen(string)+1) ){
                perror("write");
                exit(1);
        }
        
        off = lseek(f, 0, SEEK_CUR);
        printf("padre (senza figli) seek: %d\n", off);

        printf("padre (senza figli) fork *\n");
        if ( (pid = fork()) < 0){
                perror("fork");
                exit(1);
        }
        if (pid > 0){
                lsofd("padre");
                printf("padre close *\n");
                printf("padre write *\n");
                off = lseek(f, 0, SEEK_CUR);
                printf("padre seek prima: %d\n", off);
                if (write(f, string, (strlen(string))) != (strlen(string)) ){
                        perror("write");
                        exit(1);
                }
                lsofd("padre");
                off = lseek(f, 0, SEEK_CUR);
                printf("padre seek dopo: %d\n", off);
                exit(0);
        }
        else {
                lsofd("figlio");
                printf("figlio close *\n");
                printf("figlio write *\n");
                off = lseek(f, 0, SEEK_CUR);
                printf("figlio seek prima: %d\n", off);
                if (write(f, string, (strlen(string))) != (strlen(string)) ){
                        perror("write");
                        exit(1);
                }
                lsofd("figlio");
                off = lseek(f, 0, SEEK_CUR);
                printf("figlio seek dopo: %d\n", off);
                exit(0);
        }
}

/* Local Variables: */
/* compile-command: "make -k " */
/* End: */
