/*	set to 16 bit mode (80x86 begin in real mode) text section to 0 */
.code16
.text
.org 0x00

.global _start
_start:
	mov $0x07C0,%ax		
	mov %ax,%ds		

	call booting
	xor %dx,%dx		/* test if dx == 0 */
	call working
	call idleloop
	ret

booting:
	mov $boot,%si
	call message
	call nl
	ret

message:
	cld			/* set direction to increment */
	lodsb
	or %al,%al
	jz done
	mov $0xE,%ah 
	mov $7,%bx
	int $0x10
	jmp message
	
done:
	ret

nl:	
	mov $newline,%si 
	call message
	ret

working:
	call nl
	call nl
	mov $device,%si
	call message
	call waitenter
	inc %dx
	cmp $3,%dx
	je keyboard
	jmp working

waitenter:
	call nl
	movw $cont,%si 
	call message
	xor %ax,%ax 	/* Sets AH=0 and AL=0 */
	int $0x16 	/* Wait for keypress */
	cmp 'T',%al 
	jz taz
	cmp 't',%al 
	jz taz
	cmp $13,%al 
	jnz waitenter
	ret

keyboard:
	call nl
	call nl
	movw $kbd,%si 
	call message
	call nl
	movw cont,%si
	call message
	ret

taz:
	call nl
	call nl
	movw tazq,%si 
	call message
	jmp waitenter

idleloop:
	hlt
	jmp idleloop

boot: 	
	.ascii "Loading UniOS 1.1 Beta..."
newline: 
	.byte 10, 13, 0
device: 
	.ascii "Device not responding to SCSI command." 
cont: 
	.ascii "Hit ENTER to continue..."
kbd: 
	.ascii "Keyboard not responding to SCSI command."
tazq: 
	.ascii "Yes, TazQ is an Internet crack monkey on wheels."

/* Fill with zero until boottag */
padlen: 
	.byte boottag - .

.fill 10,1,0	
/*	times 510-($-$$) db 0 */

.org 510
boottag:
	.word 0xAA55
