/* Copyright (C) 2009 by Mattia Monga <mattia.monga@unimi.it> */
/* $Id$ */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

pthread_t p1,p2,p3;

pthread_mutex_t lock = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t dodici = PTHREAD_COND_INITIALIZER;
int contatore = 0;



void* guardiano(void* x){
        pthread_mutex_lock(&lock);
        while ( contatore < 12){
                printf("Going to block...........\n");
                pthread_cond_wait(&dodici, &lock);
                printf("Watcher alive...........\n");
        }
        pthread_mutex_unlock(&lock);
        printf("Dodici!!!!!\n");
        return NULL;
}

// Il corpo del ciclo viene eseguito mantenendo il lock
void* incrementatore1(void* x){
        while(pthread_mutex_lock(&lock), contatore < 12){
                contatore += 1;
                printf("Sono pippo e sto incrementando: %d\n ", 
                       contatore);
                if (contatore == 12) {
                        printf("Sveglia da pippo!!!!!\n");
                        pthread_cond_signal(&dodici);
                }
                pthread_mutex_unlock(&lock);
                pthread_yield();
        }
        pthread_mutex_unlock(&lock);
        return NULL;
}

// come il precedente ma scritto con do-while forse e` piu` chiaro
void* incrementatore2(void* x){
        do { 
                pthread_mutex_lock(&lock);
                contatore += 1;
                printf("Sono pluto e sto incrementando: %d\n ", 
                       contatore);
                if (contatore == 12){
                        printf("Sveglia da pluto!!!!!\n");
                        pthread_cond_signal(&dodici);
                }
                pthread_mutex_unlock(&lock);
                pthread_yield();
        } while (contatore < 12);
        return NULL;
}




int main(void){

        pthread_create(&p1, NULL, incrementatore1, NULL);
        pthread_create(&p2, NULL, incrementatore2, NULL);
        pthread_create(&p3, NULL, guardiano, NULL);

        pthread_join(p1, NULL);
        pthread_join(p2, NULL);
        pthread_join(p3, NULL);
        
        return 0;
}

    
        
  



/* Local Variables: */
/* compile-command: "make -k " */
/* End: */
