; Redistribution and use in source and binary forms, with or without modification, are
; permitted provided that the following conditions are met:
;
; Redistributions of source code must retain the above copyright notice, this list of
; conditions and the following disclaimer.
;
; Redistributions in binary form must reproduce the above copyright notice, this list of
; conditions and the following disclaimer in the documentation and/or other materials
; provided with the distribution.
;
; The name of the author may not be used to endorse or promote products derived from this
; software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
; INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
; A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
; LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
; Version: 1.1.1 Beta

bits 16
org 0h

	mov ax, 0x7C0
	mov ds, ax

	call booting
	xor dx,dx
	call working
	call idleloop

nl:
	mov si, newline
	call message
	ret
	
booting:
	mov si, boot
	call message
	call nl
	ret
	
working:
	call nl
	call nl
	mov si, device
	call message
	call waitenter;
	inc dx
	cmp dx, 3
	je keyboard
	jmp working

keyboard:
	call nl
	call nl
	mov si, kbd
	call message
	call nl
	mov si, cont
	call message
	ret

waitenter:
	call nl
	mov si, cont
	call message
	xor ax,ax ; Sets AH=0 and AL=0
	int 16h ; Wait for keypress
	cmp al, 'T'
	jz taz
	cmp al, 't'
	jz taz
	cmp al, 13
	jnz waitenter
	ret

taz:
	call nl
	call nl
	mov si, tazq
	call message
	jmp waitenter

idleloop:
	hlt
	jmp idleloop

message:
	lodsb
	or al, al
	jz done
	mov ah, 0Eh
	mov bx, 7
	int 10h
	jmp message
	
done:
	ret
 
boot: db 'Loading UniOS 1.1 Beta...' , 0
newline: db 10, 13, 0
device: db 'Device not responding to SCSI command.' , 0 
cont: db 'Hit ENTER to continue...', 0
kbd: db 'Keyboard not responding to SCSI command.' , 0
tazq: db 'Yes, TazQ is an Internet crack monkey on wheels.' , 0

	times 510-($-$$) db 0
	dw 0xAA55