echo x - ctags.man
sed '/^X/s///' > ctags.man << '/'
X.TH CTAGS 1
X.SH NAME
Xctags - Generates "tags" and (optionally) "refs" files
X.SH SYNOPSIS
X\fBctags\fP [\fB-stvra\fP] \fIfilesnames\fP...
X.SH DESCRIPTION
X\fIctags\fP generates the "tags" and "refs" files
Xfrom a group of C source files.
XThe "tags" file is used by Elvis' ":tag" command,
Xcontrol-] command,
Xand -t option.
XThe "refs" file is sometimes used by the \fIref(1)\fP program.
X.PP
XEach C source file is scanned for #define statements and
Xglobal function definitions.
XThe name of the macro or function becomes the name of a tag.
XFor each tag, a line is added to the "tags" file which contains:
X.RS
X.nf
X       - the name of the tag
X       - a tab character
X       - the name of the file containing the tag
X       - a tab character
X       - a way to find the particular line within the file.
X.RE
X.fi
X.PP
XThe filenames list will typically be the names of all C source
Xfiles in the current directory, like this:
X.RS
X.nf
X$ ctags -stv *.[ch]
X.RE
X.fi
X.SH OPTIONS
X.IP \fB-t\fR
XInclude typedefs.
XA tag will be generated for each user-defined type.
XAlso tags will be generated for struct and enum names.
XTypes are considered to be global if they are defined in a header file,
Xand static if they are defined in a C source file.
X.IP \fB-v\fR
XInclude variable declarations.
XA tag will be generated for each variable, except for those that are declared
Xinside the body of a function.
X.IP \fB-s\fR
XInclude static tags.
X\fICtags\fR will normally put global tags in the "tags" file, and silently ignore
Xthe static tags.
XThis flag causes both global and static tags to be added.
XThe name of a static tag is generated by prefixing the name of the declared
Xitem with the name of the file where it is defined, with a colon in between.
XFor example, "static foo(){}" in "bar.c" results in a tag named "bar.c:foo".
X.IP \fB-r\fP
XThis causes \fIctags\fP to generate both "tags" and "refs".
XWithout \fB-r\fP, it would only generate "tags".
X.IP \fB-a\fR
XAppend to "tags", and maybe "refs".
XNormally, \fIctags\fR overwrites these files each time it is invoked.
XThis flag is useful when you have to many files in the current directory
Xfor you to list them on a single command-line;
Xit allows you to split the arguments among several invocations.
X.SH FILES
X.IP tags
XA cross-reference that lists each tag name, the name of the source file that
Xcontains it, and a way to locate a particular line in the source file.
X.IP refs
XThe "refs" file contains the definitions for each tag in the "tags" file,
Xand very little else.
XThis file can be useful, for example, when licensing restrictions prevent
Xyou from making the source code to the standard C library readable by everybody,
Xbut you still everybody to know what arguments the library functions need.
X.SH BUGS
X.PP
X\fIctags\fR is sensitive to indenting and line breaks.
XConsequently, it might not discover all of the tags in a file that
Xis formatted in an unusual way.
X.SH "SEE ALSO"
Xelvis(1), refs(1)
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
/
echo x - elvis.man
sed '/^X/s///' > elvis.man << '/'
X.TH ELVIS 1
X.SH NAME
Xelvis, ex, vi, view, input - The editor
X.SH SYNOPSIS
X\fBelvis\fP [\fIflags\fP] [\fB+\fP\fIcmd\fP] [\fIfiles\fP...]
X.SH DESCRIPTION
X\fIElvis\fP is a text editor which emulates \fIvi\fP/\fIex\fP.
X.PP
XOn systems which pass the program name as an argument, such as Unix and Minix,
Xyou may also install \fIelvis\fP under the names "ex", "vi", "view", and "input".
XThese extra names would normally be links to elvis;
Xsee the "ln" shell command.
X.PP
XWhen \fIelvis\fP is invoked as "vi",
Xit behaves exactly as though it was invoked as "elvis".
XHowever, if you invoke \fIelvis\fP as "view",
Xthen the readonly option is set as though you had given it the "-R" flag.
XIf you invoke \fIelvis\fP as "ex",
Xthen \fIelvis\fP will start up in the colon command mode
Xinstead of the visual command mode,
Xas though you had given it the "-e" flag.
XIf you invoke \fIelvis\fP as "input" or "edit",
Xthen \fIelvis\fP will start up in input mode,
Xas though the "-i" flag was given.
X.SH OPTIONS
X.IP \fB-r\fP
XTo the real vi, this flag means that a previous edit should be recovered.
X\fIElvis\fP, though, has a separate program, called \fIelvrec(1)\fP, for recovering
Xfiles.
XWhen you invoke \fIelvis\fP with -r, \fIelvis\fP will tell you to run \fIelvrec\fP.
X.IP \fB-R\fP
XThis sets the "readonly" option,
Xso you won't accidentally overwrite a file.
X.IP "\fB-t\fP \fItag\fP"
XThis causes \fIelvis\fP to start editing at the given tag.
X.IP "\fB-m\fP [\fIfile\fP]"
X\fIElvis\fP will search through \fIfile\fP for something that looks like
Xan error message from a compiler.
XIt will then begin editing the source file that caused the error,
Xwith the cursor sitting on the line where the error was detected.
XIf you don't explicitly name a \fIfile\fP, then "errlist" is assumed.
X.IP \fB-e\fP
X\fIElvis\fP will start up in colon command mode.
X.IP \fB-v\fP
X\fIElvis\fP will start up in visual command mode.
X.IP \fB-i\fP
X\fIElvis\fP will start up in input mode.
X.IP "\fB-w\fR \fIwinsize\fR"
XSets the "window" option's value to \fIwinsize\fR.
X.IP "\fB+\fP\fIcommand\fP or \fB-c\fP \fIcommand\fP"
XIf you use the +\fIcommand\fP parameter,
Xthen after the first file is loaded
X\fIcommand\fP is executed as an EX command.
XA typical example would be "elvis +237 foo",
Xwhich would cause \fIelvis\fP to start editing foo and
Xthen move directly to line 237.
XThe "-c \fIcommand\fP" variant was added for UNIX SysV compatibility.
X.SH FILES
X.IP /tmp/elv*
XDuring editing,
X\fIelvis\fP stores text in a temporary file.
XFor UNIX, this file will usually be stored in the /tmp directory,
Xand the first three characters will be "elv".
XFor other systems, the temporary files may be stored someplace else;
Xsee the version-specific section of the documentation.
X.IP tags
XThis is the database used by the \fI:tags\fP command and the \fB-t\fP option.
XIt is usually created by the \fIctags(1)\fP program.
X.IP ".exrc or elvis.rc"
XOn UNIX-like systems, a file called ".exrc" in your home directory
Xis executed as a series of \fIex\fR commands.
XA file by the same name may be executed in the current directory, too.
XOn non-UNIX systems, ".exrc" is usually an invalid file name;
Xthere, the initialization file is called "elvis.rc" instead.
X.SH "SEE ALSO"
Xctags(1), ref(1), virec(1)
X.PP
X\fIElvis - A Clone of Vi/Ex\fP, the complete \fIelvis\fP documentation.
X.SH BUGS
XThere is no LISP support.
XCertain other features are missing, too.
X.PP
XAuto-indent mode is not quite compatible with the real vi.
XAmong other things, 0^D and ^^D don't do what you might expect.
X.PP
XLong lines are displayed differently.
XThe real vi wraps long lines onto multiple rows of the screen,
Xbut \fIelvis\fP scrolls sideways.
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
X.PP
XMany other people have worked to port \fIelvis\fP to various operating systems.
XTo see who deserves credit, run the \fI:version\fP command from within \fIelvis\fP,
Xor look in the system-specific section of the complete documentation.
/
echo x - elvprsv.man
sed '/^X/s///' > elvprsv.man << '/'
X.TH ELVPRSV 1
X.SH NAME
Xelvprsv - Preserve the the modified version of a file after a crash.
X.SH SYNOPSIS
X.nf
X\fB\fBelvprsv\fP ["-\fIwhy elvis died\fP"] /tmp/\fIfilename\fP...
X\fB\fBelvprsv\fP -R /tmp/\fIfilename\fP...
X.fi
X.SH DESCRIPTION
X.PP
X\fIelvprsv\fP preserves your edited text after \fIelvis\fP dies.
XThe text can be recovered later, via the \fIelvprsv\fP program.
X.PP
XFor UNIX-like systems,
Xyou should never need to run this program from the command line.
XIt is run automatically when \fIelvis\fP is about to die,
Xand it should be run (via /etc/rc) when the computer is booted.
XTHAT'S ALL!
X.PP
XFor non-UNIX systems such as MS-DOS, you can either use \fIelvprsv\fP
Xthe same way as under UNIX systems (by running it from your AUTOEXEC.BAT file),
Xor you can run it separately with the "-R" flag to recover the files
Xin one step.
X.PP
XIf you're editing a file when \fIelvis\fP dies
X(due to a bug, system crash, power failure, etc.)
Xthen \fIelvprsv\fP will preserve the most recent version of your text.
XThe preserved text is stored in a special directory; it does NOT overwrite
Xyour text file automatically.
X.PP
X\fIelvprsv\fP will send mail to any user whose work it preserves,
Xif your operating system normally supports mail.
X.SH FILES
X.IP /tmp/elv*
XThe temporary file that \fIelvis\fP was using when it died.
X.IP /usr/preserve/p*
XThe text that is preserved by \fIelvprsv\fP.
X.IP /usr/preserve/Index
XA text file which lists the names of all preserved files, and the names
Xof the /usr/preserve/p* files which contain their preserved text.
X.SH BUGS
X.PP
XDue to the permissions on the /usr/preserve directory, on UNIX systems
X\fIelvprsv\fP must be run as superuser.
XThis is accomplished by making the \fIelvprsv\fP executable be owned by "root"
Xand turning on its "set user id" bit.
X.PP
XIf you're editing a nameless buffer when \fIelvis\fP dies, then \fIelvprsv\fP will pretend
Xthat the file was named "foo".
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
/
echo x - elvrec.man
sed '/^X/s///' > elvrec.man << '/'
X.TH ELVREC 1
X.SH NAME
Xelvrec - Recover the modified version of a file after a crash
X.SH SYNOPSIS
X.nf
X\fBelvrec\fP [\fIpreservedfile\fP [\fInewfile\fR]]
X.fi
X.SH DESCRIPTION
X.PP
XIf you're editing a file when \fIelvis\fP dies, the system crashes, or power fails,
Xthe most recent version of your text will be preserved.
XThe preserved text is stored in a special directory; it does NOT overwrite
Xyour text file automatically.
X.PP
XThe \fIelvrec\fP program locates the preserved version of a given file,
Xand writes it over the top of your text file -- or to a new file, if you prefer.
XThe recovered file will have nearly all of your changes.
X.PP
XTo see a list of all recoverable files, run \fIelvrec\fP with no arguments.
X.SH FILES
X.IP /usr/preserve/p*
XThe text that was preserved when \fIelvis\fP died.
X.IP /usr/preserve/Index
XA text file which lists the names of all preserved files, and the names
Xof the /usr/preserve/p* files which contain their preserved text.
X.SH BUGS
X.PP
X\fIelvrec\fP is very picky about filenames.
XYou must tell it to recover the file using exactly the same pathname as
Xwhen you were editing it.
XThe simplest way to do this is to go into the same directory that you were
Xediting, and invoke \fIelvrec\fP with the same filename as \fIelvis\fP.
XIf that doesn't work, then try running \fIelvrec\fP with no arguments,
Xto see exactly which pathname it is using for the desired file.
X.PP
XDue to the permissions on the /usr/preserve directory, on UNIX systems
X\fIelvrec\fP must be run as superuser.
XThis is accomplished by making the \fIelvrec\fP executable be owned by "root"
Xand setting its "set user id" bit.
X.PP
XIf you're editing a nameless buffer when \fIelvis\fP dies, then \fIelvrec\fP
Xwill pretend that the file was named "foo".
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
/
echo x - fmt.man
sed '/^X/s///' > fmt.man << '/'
X.TH FMT 1
X.SH NAME
Xfmt - adjust line-length for paragraphs of text
X.SH SYNOPSIS
X\fBfmt\fP [\-\fIwidth\fP] [\fIfiles\fP]...
X.SH DESCRIPTION
X\fIfmt\fR is a simple text formatter.
XIt inserts or deletes newlines, as necessary, to make all lines in a
Xparagraph be approximately the same width.
XIt preserves indentation and word spacing.
X.PP
XThe default line width is 72 characters.
XYou can override this with the \-\fIwidth\fR flag.
XIf you don't name any files on the command line,
Xthen \fIfmt\fR will read from stdin.
X.PP
XIt is typically used from within \fIvi\fR to adjust the line breaks
Xin a single paragraph.
XTo do this, move the cursor to the top of the paragraph,
Xtype "!}fmt", and
Xhit <Return>.
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
/
echo x - ref.man
sed '/^X/s///' > ref.man << '/'
X.TH REF 1
X.SH NAME
Xref - Display a C function header
X.SH SYNOPSIS
X\fBref\fR [-t] [-c \fIclass\fR]... [-f \fIfile\fR]... \fItag\fR
X.SH DESCRIPTION
X\fIref\fP quickly locates and displays the header of a function.
XTo do this, \fIref\fR
Xlooks in the "tags" file for the line that describes the function, and then 
Xscans the source file for the function.
XWhen it locates the function, it displays an introductory comment
X(if there is one), the function's declaration, and the declarations of all
Xarguments.
X.SH "SEARCH METHOD"
X.PP
X\fIref\fR uses a fairly sophisticated tag look-up algorithm.
XIf you supply a filename via \fB-f\fR \fIfile\fR, then elvis first scans
Xthe tags file for a static tag from that file.
XThis search is limited to the tags file in the current directory.
X.PP
XIf you supply a classname via \fB-c\fR \fIclass\fR, then elvis searches
Xfor a tag from that class.
XThis search is not limited to the current directory;
XYou can supply a list of directories in the environment variable \fITAGPATH\fR,
Xand \fIref\fR will search through the "tags" file in each directory until it finds
Xa tag in the desired class.
X.PP
XIf that fails, \fIref\fR will then try to look up an ordinary global tag.
XThis search checks all of the directories listed in \fITAGPATH\fR, too.
X.PP
XIf you've given the \fB-t\fR flag, then \fIref\fR will simply output the tag line that
Xit found, and then exit.
XWithout \fB-t\fR, though, \fIref\fR will search for the tag line.
XIt will try to open the source file, which should be in the same directory
Xas the tags file where the tag was discovered.
XIf the source file doesn't exist, or is unreadable, then \fIref\fR will try to open
Xa file called "\fIrefs\fR" in that directory.
XEither way, \fIref\fR will try to locate the tag, and display whatever it finds.
X.SH "INTERACTION WITH ELVIS"
X.PP
X\fIref\fP is used by \fIelvis\fR' shift-K command.
XIf the cursor is located on a word such as "splat", in the file "foo.c",
Xthen \fIelvis\fR will invoke \fIref\fR with the command "ref -f foo.c splat".
X.PP
XIf \fIelvis\fR has been compiled with the -DEXTERNAL_TAGS flag, then \fIelvis\fR will
Xuse \fIref\fR \fB\fRto scan the tags files.
XThis is slower than the built-in tag searching, but it allows \fIelvis\fR to access
Xthe more sophisticated tag lookup provided by \fIref\fR.
XOther than that, external tags should act exactly like internal tags.
X.SH OPTIONS
X.IP \fB-t\fR
XOutput tag info, instead of the function header.
X.IP "\fB-f\fR \fIfile\fR"
XThe tag might be a static function in \fIfile\fR.
XYou can use several -f flags to have \fIref\fR consider static tags from more than one file.
X.IP "\fB-c\fR \fIclass\fR"
XThe tag might be a member of class \fIclass\fR.
XYou can use several -c flags to have \fIref\fR consider tags from more than one class.
X.SH FILES
X.IP \fBtags\fR
XList of function names and their locations, generated by \fIctags\fR.
X.IP \fBrefs\fR
XFunction headers extracted from source files (optional).
X.SH ENVIRONMENT
X.IP \fBTAGPATH\fR
XList of directories to be searched.
XThe elements in the list are separated by either
Xsemicolons (for MS-DOS, Atari TOS, and AmigaDos), or
Xby colons (every other operating system).
XFor each operating system, \fIref\fR has a built-in default which is probably
Xadequate.
X.SH NOTES
X.PP
XYou might want to generate a "tags" file the directory that contains the
Xsource code for standard C library on your system.
XIf licensing restrictions prevent you from making the library source readable
Xby everybody, then you can have \fIctags\fR generate a "refs" file,
Xand make "refs" readable by everybody.
X.PP
XIf your system doesn't come with the library source code, then perhaps you
Xcan produce something workable from the \fIlint\fR libraries.
X.SH "SEE ALSO"
Xelvis(1), ctags(1)
X.SH AUTHOR
X.nf
XSteve Kirkendall
Xkirkenda@cs.pdx.edu
X.fi
/
